<?php

class BusyRooms_SearchBox extends WP_Widget {

	

	public function __construct() {
		parent::__construct(
			'busyrooms_searchbox',
			__( 'BusyRooms SearchBox', 'busyrooms' ),
			array(
				'customize_selective_refresh' => true,
			)
		);
	}

	public function form( $instance ) {

		// Set widget defaults
		$defaults = array(
			'title'    => 'BusyRooms SearchBox',
			'website_id' => '1234',
			'max_rooms' => 1,
			'enable_flights' => true,
			'max_adults_per_room' => 5,
			'max_children_per_room' => 3,
			'max_child_age' => 17
		);
		
		// Parse current settings with defaults
		extract( wp_parse_args( ( array ) $instance, $defaults ) ); ?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Widget Title', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'website_id' ) ); ?>"><?php _e( 'Website Identifier', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'website_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'website_id' ) ); ?>" type="text" value="<?php echo esc_attr( $website_id ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'max_rooms' ) ); ?>"><?php _e( 'Max Rooms', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'max_rooms' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'max_rooms' ) ); ?>" type="number" value="<?php echo esc_attr( $max_rooms ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'max_adults_per_room' ) ); ?>"><?php _e( 'Max adults per room', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'max_adults_per_room' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'max_adults_per_room' ) ); ?>" type="number" value="<?php echo esc_attr( $max_adults_per_room ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'max_children_per_room' ) ); ?>"><?php _e( 'Max children per room', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'max_children_per_room' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'max_children_per_room' ) ); ?>" type="number" value="<?php echo esc_attr( $max_children_per_room ); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'max_child_age' ) ); ?>"><?php _e( 'Max child age', 'busyrooms' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'max_child_age' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'max_child_age' ) ); ?>" type="number" value="<?php echo esc_attr( $max_child_age ); ?>" />
		</p>

		<p>
			<input id="<?php echo esc_attr( $this->get_field_id( 'enable_flights' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'enable_flights' ) ); ?>" type="checkbox" value="1" <?php checked( '1', $enable_flights ); ?> />
			<label for="<?php echo esc_attr( $this->get_field_id( 'enable_flights' ) ); ?>"><?php _e( 'Enable Flights', 'busyrooms' ); ?></label>
		</p>

	<?php }

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title']    = isset( $new_instance['title'] ) ? wp_strip_all_tags( $new_instance['title'] ) : '';
		$instance['website_id']    = isset( $new_instance['website_id'] ) ? wp_strip_all_tags( $new_instance['website_id'] ) : '';
		$instance['max_rooms']    = isset( $new_instance['max_rooms'] ) ? wp_strip_all_tags( $new_instance['max_rooms'] ) : '';
		$instance['max_adults_per_room']    = isset( $new_instance['max_adults_per_room'] ) ? wp_strip_all_tags( $new_instance['max_adults_per_room'] ) : '';
		$instance['max_children_per_room']    = isset( $new_instance['max_children_per_room'] ) ? wp_strip_all_tags( $new_instance['max_children_per_room'] ) : '';
		$instance['max_child_age']    = isset( $new_instance['max_child_age'] ) ? wp_strip_all_tags( $new_instance['max_child_age'] ) : '';
		$instance['enable_flights'] = isset( $new_instance['enable_flights'] ) ? 1 : false;
		return $instance;
	}

	public function widget( $args, $instance ) {

		extract( $args );

		// Check the widget options
		$title    = isset( $instance['title'] ) ? apply_filters( 'widget_title', $instance['title'] ) : '';
		$website_id = isset( $instance['website_id']) ? $instance['website_id'] : '';
		$max_rooms = isset( $instance['max_rooms']) ? $instance['max_rooms'] : '';
		$max_adults_per_room = isset( $instance['max_adults_per_room']) ? $instance['max_adults_per_room'] : '';
		$max_children_per_room = isset( $instance['max_children_per_room']) ? $instance['max_children_per_room'] : '';
		$max_child_age = isset( $instance['max_child_age']) ? $instance['max_child_age'] : '';
		$enable_flights = ! empty( $instance['enable_flights'] ) ? $instance['enable_flights'] : false;

		// WordPress core before_widget hook (always include )
		echo $before_widget;

		$keys = array(
			"Room"
			,"Number of adults"
			,"Number of children"
			,"Children ages"
			,"All establishments"
		);

		$translated = array();

		foreach($keys as $key) {
			$translated[$key] = __($key, "busyrooms");
		}

		$translationsJson =  htmlspecialchars(json_encode($translated), ENT_COMPAT);
		
?>
		<div class="widget-text wp_widget_plugin_box" id="br_searchbox">

			<?php 
			if ( $title ) {
				echo $before_title . $title . $after_title;
			}
			?>

		<input id="br_searchbox_translations" type="hidden" value="<?php echo $translationsJson ?>" />
		<input id="br_searchbox_enable_flights" type="hidden" value="<?php echo $enable_flights ? "true" : "false" ?>">
		<input id="br_searchbox_blog_language" type="hidden" value="<?php echo $lang=get_bloginfo("language"); ?>" />
		
		<input type="hidden" id ="br_searchbox_max_adults_per_room" value="<?php echo $max_adults_per_room ?>" />
		<input type="hidden" id ="br_searchbox_max_children_per_room" value="<?php echo $max_children_per_room ?>" />
		<input type="hidden" id ="br_searchbox_max_child_age" value="<?php echo $max_child_age ?>" />
		
		<?php if($enable_flights) { ?>
		<p id="br_searchbox_with_flight_container">
			<label for="br_searchbox_with_flight">
			<?php echo __('With Flight?', 'busyrooms') ?>
			</label>
			<input id="br_searchbox_with_flight" type="checkbox"></select>
		</p>

		<div class="ui-widget">
			<p id="br_searchbox_origin_container">
				<label for="br_searchbox_origin">
				<?php echo __('Origin Airport', 'busyrooms') ?>
				</label>
				<input id="br_searchbox_origin" type="text" />
			</p>
		</div>

		<?php } ?>

		<p>
			<label for="br_searchbox_destination">
			<?php echo __('Destination', 'busyrooms') ?>
			</label>
			<select id="br_searchbox_destination"></select>
		</p>

		<p>
			<label for="br_searchbox_establishment">
			<?php echo __('Establishment', 'busyrooms') ?>
			</label>
			<select id="br_searchbox_establishment"></select>
		</p>

		<p>
			<label for="br_searchbox_checkin">
			<?php echo __('Check In', 'busyrooms') ?>
			</label>
			<input type="date" id="br_searchbox_checkin"/>
		</p>

		<p>
			<label for="br_searchbox_checkout">
			<?php echo __('Check Out', 'busyrooms') ?>
			</label>
			<input type="date" id="br_searchbox_checkout"/>
		</p>

		<p>
			<label for="br_searchbox_count_rooms">
			<?php echo __('Number of rooms', 'busyrooms') ?>
			</label>
			<input type="number" id="br_searchbox_count_rooms" min="1" max="<?php echo $max_rooms ?>" value="1"/>
		</p>

		<p>
			<div id="br_searchbox_rooms_container">
			</div>
		</p>
		<p>
			<button id="br_searchbox_submit">
			<?php echo __('Submit', 'busyrooms') ?>
			</button>
		</p>

		<input type="hidden" id ="br_searchbox_website_id" value="<?php echo $website_id ?>"/>

		</div>
		<?php

		// WordPress core after_widget hook (always include )
		echo $after_widget;

	}
}