<?php

/**
 * Plugin Name: Busy Rooms
 * Plugin URI: https://www.busy-rooms.com
 * Version: 0.1.0
 */

require_once dirname( __FILE__ ) .'/widgets/searchbox.php';

function busyrooms_register_widget_search() {
	register_widget('busyrooms_searchbox');
}

function busyrooms_register_scripts() {
	wp_enqueue_script( 'busyrooms_searchbox_script', plugin_dir_url( __FILE__ ) . 'public/busyrooms_searchbox.js', array('jquery','wp-i18n','jquery-ui-core', 'jquery-ui-autocomplete'), '1.0' );
	wp_set_script_translations('busyrooms_searchbox_script', 'busyrooms');
	
	wp_enqueue_style('jquery_ui_base', '//ajax.googleapis.com/ajax/libs/jqueryui/1.8/themes/base/jquery-ui.css');
	wp_enqueue_style( 'busyrooms_searchbox_style', plugin_dir_url( __FILE__ ) . 'public/busyrooms_searchbox.css', array(), '1.0' );
}

function busyrooms_load_plugin_textdomain() {
    load_plugin_textdomain( 'busyrooms', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}

add_action('plugins_loaded', 'busyrooms_load_plugin_textdomain' );
add_action('wp_enqueue_scripts', 'busyrooms_register_scripts', 9999);
add_action('widgets_init', 'busyrooms_register_widget_search');